///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains DLL related code.
 *	\file		IceDll.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEDLL_H__
#define __ICEDLL_H__

extern void ModuleAttach(udword hmod);
extern void ModuleDetach();

#if defined(_USRDLL) && defined(ICE_MAIN)

	BOOL APIENTRY DllMain(HANDLE hModule, udword ul_reason_for_call, void* lpReserved)
	{
		switch (ul_reason_for_call)
		{
			case DLL_PROCESS_ATTACH:
				ModuleAttach((udword)hModule);
				break;

			case DLL_PROCESS_DETACH:
				ModuleDetach();
				break;
		}
		return true;
	}

#endif

#ifdef _DEBUG

ICECORE_API inline void IceTrace(const char* lpszFormat, ...)
{
	va_list args;
	va_start(args, lpszFormat);

	sdword nBuf;
	ubyte szBuffer[512];

	nBuf = _vsnprintf((LPSTR)szBuffer, lstrlen((LPCSTR)szBuffer), (LPCSTR)lpszFormat, args);

	_RPT0(_CRT_WARN, szBuffer);

	va_end(args);
}

#endif // _DEBUG

#endif // __ICEDLL_H__
